﻿//////////////////////////////////////////////
// RasterStateManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "RasterState.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RasterStateManager : public Manager<RasterState>, public nkCommon::MaybeSingletonClass<RasterStateManager>
	{		
		public :

			// Getters
			RasterState* getDefaultState () const ;

		private :

			// Functions
			// Constructors
			RasterStateManager (bool isSingleton) noexcept ;
			RasterStateManager (System* system) noexcept ;

			// Lifetime
			void _initializeDefaultState () ;

		private :

			// Attributes
			nkMemory::UniquePtr<RasterState> _defaultState ;

		private :

			friend class nkCommon::MaybeSingletonClass<RasterStateManager> ;
			friend class System ;
	} ;
}